package gov.va.vinci.dart;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.json.ErrorView;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.PersonTask;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.json.CreateActivityView;
import gov.va.vinci.dart.json.NewActivityView;
import gov.va.vinci.dart.json.TaskAgingView;
import gov.va.vinci.dart.json.TaskListView;
import gov.va.vinci.dart.json.TaskView;
import gov.va.vinci.dart.json.UserIdView;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

public class TestTaskController extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testOne() throws Exception {

		TaskController tc = SingletonShim.getBean(TaskController.class);

		Object obj = tc.getUserTasks(null);
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof ErrorView);
		Assert.assertNotEquals(((ErrorView)obj).getMessage().get("text"), "OK");		

		// don't test passing an invalid user id - the method does not use it.
		
		UserIdView uiv = new UserIdView();
		uiv.setUserId(1005);
		
		obj = tc.getUserTasks(uiv);
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof TaskListView);
		TaskListView tlv = (TaskListView)obj;
		
		Assert.assertNotNull(tlv);
		Assert.assertNotNull(tlv.getTasks());
		
		// we don't know how many tasks exist for this user right now.
		int previousTaskCount = tlv.getTasks().size();
		
		CreateActivityView req = new CreateActivityView ();
		
		ActivityController ac = SingletonShim.getBean(ActivityController.class);
		req.setType(Request.DATA_ACCESS);
		req.setOfficialName("official name");
		
		// now see if we can create it correctly
		obj = ac.createActivity(req);
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof NewActivityView);
		
		NewActivityView nav = (NewActivityView)obj;
		Assert.assertTrue(nav.getActivityId() > 0);
		Assert.assertTrue(nav.getRequestId() > 0);

		// now we have a request to work with
		
		// create a task against it
		Request request = Request.findById(nav.getRequestId());
		Person person = Person.findById(1004);  // this should be the id of DNS that was authenticated in test setup
		PersonTask personTask = PersonTask.create(null, request, person, "Person Task Name", "Person Task Description", "DNS");
		Assert.assertNotNull(personTask);
		
		Role.initialize();
		if( person.hasRole(Role.NDS_ADMIN) == false && person.hasRole(Role.REVIEWER) == false && person.hasRole(Role.READ_ONLY_STAFF) == false ) {

			obj = tc.getUserTasks(uiv);
			Assert.assertNotNull(obj);
			Assert.assertTrue(obj instanceof TaskListView);
			tlv = (TaskListView)obj;
			
			Assert.assertNotNull(tlv);
			Assert.assertNotNull(tlv.getTasks());
	
			int subsequentTaskCount = tlv.getTasks().size();
	
			Assert.assertTrue(subsequentTaskCount >= previousTaskCount);
	
			boolean foundit = false;
			
			for(TaskView tv : tlv.getTasks()) {
				Assert.assertNotNull(tv);
				if ("Person Task Description".equals(tv.getDescription()) == true) {
					foundit = true;
					break;
				}
			}
			
			Assert.assertTrue(foundit);

		}
	}

	@Test
	public void testTwo() throws Exception {

		TaskController tc = SingletonShim.getBean(TaskController.class);

		Object obj = tc.getTaskAging(null);
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof ErrorView);
		Assert.assertNotEquals(((ErrorView)obj).getMessage().get("text"), "OK");		

		UserIdView uiv = new UserIdView();

		// don't test passing an invalid user id to the method.  it doesn't use it.
		
		uiv.setUserId(1006);
		
		obj = tc.getTaskAging(uiv);
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof TaskAgingView);
		TaskAgingView tav = (TaskAgingView)obj;

		Assert.assertTrue(tav.getDay0() >= 0);
		Assert.assertTrue(tav.getDay10() >= 0);
		Assert.assertTrue(tav.getDay20() >= 0);
		Assert.assertTrue(tav.getDay30() >= 0);
		
	}

	/*
	 * getUserTasks
	 * completeTask
	 */
}
